/*------------------------------------------------------------------------------*
 * File Name: GetNDlg2.cpp														*
 * Creation: ML 2/14/2006														*
 * Purpose: Origin C for GetNBox dlgs that work with DynaControl				*
 * Copyright (c) OriginLab Corp. 2006, 2007, 2008, 2009, 2010, 2011, 2012		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	ML 2/14/2006 NEW_TREECONTROL_FOR_GetNBoxDlg									*
 *	ML 4/6/2006 ACCOMMODATE_SCROLLBARS											*
 *  Iris 5/16/05 THEME_WORK_FOR_ANALYSIS_DYNA_BOX								*
 *	TD 5-26-06 QA70-8428 EDITBOX_WITH_BUTTON									*
 *	Cheney 2006-06-21 QA70-8740 SAVING_BRANCH_IN_OPERATION_BASED_DIALOG			*
 *	CPY TD 6-30-06 QA70-8792 ALLOW_RESIZING										*
 *	CPY 6-30-06 QA70-8792 GETN_RESIZING_FROM_ATTRIBUTE							*
 *	CPY 7/3/06 QA70-8798 DYNABOX_BETTER_EVENTS									*
 *	CPY 7/5/06 QA70-8798 ON_OK_EVENT_TO_ALLOW_XF_HANDLING						*
 *	Cheney 2006-07-26 IF_NO_DIALOG_TITLE_NOT_LOAD_AND_SAVE						*
 *	Cheney 2006-9-22 MOVE_BRANCH_LOADING_AND_SAVING_FROM_DYNABOX_TO_DYNADLG		*
 *	CPY 10/27/06 ASCII_OPTN_DLG_UPDATE_BUTTON_DISABLED							*
 *	CPY 10/26/06 QA70-9063 DYNAMIC_ERR_MSG_IN_GETN_DIALOGS						*
 *	CPY 10/29/06 QA70-9063 DYNAMIC_ERR_MSG_IN_GETN_DIALOGS_SMART_HEIGHT			*
 *  Iris 11/10/06 HIDE_SHOWADVAN_BOX											*
 *	Joseph 12/07/06	ADD_MESSAGE_BOX												*		
 *	Jasmine 02/02/07 QA70-9336 FIX_XF_NO_THEME_BUG								*
 *	CPY 2/24/2007 XF_SIMPLE_GETN_DLG_NOT_INIT_RESIZED							*
 *	Sim 03-24-2007 FIX_CUSTOM_BUTTON											*
 *	CPY 5/28/2007 QA70-9839 GETNBOX_BETTER_POSITION_CNTRL						*
 *	Folger 07/20/07 USE_BITMAP_RADIO_BUTTON_INSTEAD_OF_TEXT_BUTTON				*
 *	Sim 07-27-2007 FIX_POS_OF_APPLY_UNDO_BTN_FOR_XF_DLG							*
 *	Sim 07-27-2007 IMPLEMENT_APPLY_AND_UNDO_MECHANISM							*
 *	Folger 11/27/07 FIX_REFRESH_BUG_IN_GETNBOX									*
 *	Sim 12-06-2007 IMPROVE_EVENT1_PARAM_STR_AUX									*
 *	YuI 02/22/08 QA80-11156 DEFAULT_XF_APPLY_BUTTON_IMPLEMENTATION				*
 *	Sim 02-28-2008 QA80-11156 XF_PANEL_APPLY_BUTTON								*
 *	Folger 03/03/08 QA80-11192 ADD_THEME_CONTROL_POPUP_MENU						*
 *  Iris 10/28/2008 QA80-12479 FIX_CANNOT_SHOW_APPLY_BTN_IN_SIMPLE_GETN			*
 *	Sim 10-31-2008 INDICATE_THEME_ON_PA_FIT_PARAM_CHANGE						*
 * Kenny 04/09/2009 QA80-13422 COUNT_APPEAR_TIMES_OF_ERR_MSG					*
 *  Iris 9/4/2009 QA80-14165-P2 FIX_STATS_ON_COL_NOT_PRO_TIP_WHEN_CHANGE_PARAM	*
 *	YuI 09/16/09 QA70-13696 XFUNCTION_EVENT2_IMPLEMENTATION						*
 *	Sim 11-13-2009 QA81-14623 NOT_CLOSE_DLG_WHEN_ENTER_PRESSED					*
 *	Folger 03/08/10 QA81-15177 GETNBOX_SUPPORT_MOVE_FIRST_LEVEL_BRANCHES_INTO_TABS
 *------------------------------------------------------------------------------*/
 
////////////////////////////////////////////////////////////////////////////////////
#include <Origin.h>

#pragma labtalk(0) //--- CPY 7/26/05 hide all functions in this file from LT access, as XF should be used instead

#include "DialogEx.h" // CPY 7/2/04 consoidate all dialog related headers into a single one

#define BASE_WINDOW ResizeDialog//MultiPaneDlg
#define DC_IN_DLG // TD 5-3-06
///------ Folger 03/08/10 QA81-15177 GETNBOX_SUPPORT_MOVE_FIRST_LEVEL_BRANCHES_INTO_TABS
#define	DYNA_TAB_ID			IDC_DYNA_TAB
///------ End GETNBOX_SUPPORT_MOVE_FIRST_LEVEL_BRANCHES_INTO_TABS
#include	"DynaDlg.h" //"TreeEditDlg2.h"
#define PEVENT_CLOSE	2
#ifndef _OC_IMG_LT_H
#include <ocImgLT.h>
#endif
//------
//#include <Profiler.h>
//#define _MEASUER_TIME
#define HOUR_GLASS			waitCursor junk;
#ifdef _MEASUER_TIME
	#include <Profiler.h>
	#define PROFILE_HRGLASS		Profiler junk;
#else
	#define PROFILE_HRGLASS		HOUR_GLASS
#endif

/// YuI 7/15/04 v7.5909 QA70-6688 OC_TOOLS_IMPLEMENTATION
#include <Tools.h>
/// end OC_TOOLS_IMPLEMENTATION
/// Iris 9/15/04 MOVE_DECLARATION_TO_HEADER
/// ML 2/14/2006 NEW_TREECONTROL_FOR_GetNBoxDlg
//#include "GetNdlg.h"
#include "DynaBox.h"
/// end NEW_TREECONTROL_FOR_GetNBoxDlg
/// End MOVE_DECLARATION_TO_HEADER



///Iris 12/27/04 IMPROVE_ACCESS_ADVAN_IDS_THEME_FILE
/////Iris 12/24/04 GENERATE_READ_BUILD_IN_ADVAN_ID_THEME
//#define		ADVAN_ID_THEME_FILE		"AdvanIDs"
//static 	Tree s_trAdvanIDs;
////end GENERATE_READ_BUILD_IN_ADVAN_ID_THEME
///End IMPROVE_ACCESS_ADVAN_IDS_THEME_FILE

/// YuI 2/17/05 XYDATARANGE_PROPERTY_IMPLEMENTATION
static HWND _get_origin_win()
{
	return GetWindow();
}
/// end XYDATARANGE_PROPERTY_IMPLEMENTATION

///Joseph 04/03/07 CHANGE_PARAMETER_SHOULD_NOT_SUPPORT_THEME_AND_AUTOUPDATE_MODE
static int _get_dynabox_resource_id(const TreeNode& trGetN)
{
	if(!trGetN)
		return -1;
	
	int nRet;
	if(is_theme_dialog(trGetN))
		nRet = IDD_DYNABOX_THEME;
	else
		nRet = IDD_DYNABOX;
	return nRet;
}
///End CHANGE_PARAMETER_SHOULD_NOT_SUPPORT_THEME_AND_AUTOUPDATE_MODE

//------ CPY 7/3/06 QA70-8798 DYNABOX_BETTER_EVENTS
//invoke internally from VC only, for use from OC, use GetNBox directly
///Joseph 01/29/07 GETN_BOX_ADD_APPLY_BUTTON
//bool DynaBox(TreeNode& tr, PEVENT_GETN pGetNEvent, LPCSTR lpcszTitle, LPCSTR lpcszDescription, HWND hWndParent)//=NULL=NULL = NULL;
/// Iris 10/28/2008 QA80-12479 FIX_CANNOT_SHOW_APPLY_BTN_IN_SIMPLE_GETN
//int DynaBox(TreeNode& tr, PEVENT_GETN pGetNEvent, LPCSTR lpcszTitle, LPCSTR lpcszDescription, HWND hWndParent, bool bShowApply)
int DynaBox(TreeNode& tr, PEVENT_GETN pGetNEvent, LPCSTR lpcszTitle, LPCSTR lpcszDescription, HWND hWndParent, bool bShowApply, PAPPLY_FUNC pfnApply)
///end FIX_CANNOT_SHOW_APPLY_BTN_IN_SIMPLE_GETN
///End GETN_BOX_ADD_APPLY_BUTTON
{
	int nID;
	int nThemeType;
	
	///Joseph 04/03/07 CHANGE_PARAMETER_SHOULD_NOT_SUPPORT_THEME_AND_AUTOUPDATE_MODE
	//clean code
	/*
	//Jasmine 02/02/07 QA70-9336 FIX_XF_NO_THEME_BUG, we should identify theme applicability of xf gui by tr.tagName
	//if( is_xf_gui_getn_tree(tr) || tr.tagName == "GUI")
	if( (is_xf_gui_getn_tree(tr) && tr.tagName.CompareNoCase(XFGUI_GETN_TAGNAME_NO_THEME) )|| tr.tagName == "GUI")
		nID = IDD_DYNABOX_THEME;
	else
		nID = IDD_DYNABOX;	
	*/
	nID = _get_dynabox_resource_id(tr);
	///End CHANGE_PARAMETER_SHOULD_NOT_SUPPORT_THEME_AND_AUTOUPDATE_MODE
	
	///Joseph 01/29/07 GETN_BOX_ADD_APPLY_BUTTON
	//DynaBoxDlg myDlg(nID, tr, lpcszTitle, lpcszDescription, pGetNEvent);
	/// Iris 10/28/2008 QA80-12479 FIX_CANNOT_SHOW_APPLY_BTN_IN_SIMPLE_GETN
	//DynaBoxDlg myDlg(nID, tr, lpcszTitle, lpcszDescription, pGetNEvent, NULL, NULL, bShowApply);
	DynaBoxDlg myDlg(nID, tr, lpcszTitle, lpcszDescription, pGetNEvent, pfnApply, NULL, bShowApply);
	//end FIX_CANNOT_SHOW_APPLY_BTN_IN_SIMPLE_GETN
	///End GETN_BOX_ADD_APPLY_BUTTON
	int nRet = myDlg.DoModalEx(hWndParent);
	///Joseph 01/29/07 GETN_BOX_ADD_APPLY_BUTTON
	if(IDCANCEL == nRet)
	{
		/// YuI 02/22/08 QA80-11156 DEFAULT_XF_APPLY_BUTTON_IMPLEMENTATION
		TreeNode trDynaTree = myDlg.GetTree();
		int nSuppress = 0;
		if( trDynaTree && trDynaTree.GetAttribute(STR_ATTRIB_SUPPRESS_COMMAND_ERROR_MESSAGE, nSuppress) && nSuppress != 0 )
			tr.SetAttribute(STR_ATTRIB_SUPPRESS_COMMAND_ERROR_MESSAGE, nSuppress);
		/// end DEFAULT_XF_APPLY_BUTTON_IMPLEMENTATION
		return 0;	//On Click Cancel, return 0 means false
	}
	else
	{	// otherwise means true
		myDlg.UpdateEditTreeNode(tr);
		return nRet;
	}
	///End GETN_BOX_ADD_APPLY_BUTTON
}
//-------
bool DynaBox2(TreeNode& tr, LPCSTR lpcszTitle, LPCSTR lpcszDescription, PAPPLY_FUNC pfn, PEVENT_FUNC pEvtFn, HWND hWndParent) //=NULL,NULL,NULL, NULL, NULL
{
	int nID;
	int nThemeType;
	///Joseph 04/03/07 CHANGE_PARAMETER_SHOULD_NOT_SUPPORT_THEME_AND_AUTOUPDATE_MODE
	/*
	//Jasmine 02/02/07 QA70-9336 FIX_XF_NO_THEME_BUG
	//if( is_xf_gui_getn_tree(tr) || tr.tagName == "GUI")
	if( (is_xf_gui_getn_tree(tr) && tr.tagName.CompareNoCase(XFGUI_GETN_TAGNAME_NO_THEME) )|| tr.tagName == "GUI")
		nID = IDD_DYNABOX_THEME;
	else
		nID = IDD_DYNABOX;
	*/	
	nID = _get_dynabox_resource_id(tr);
	///End CHANGE_PARAMETER_SHOULD_NOT_SUPPORT_THEME_AND_AUTOUPDATE_MODE
//	DynaBoxDlg(int nID, TreeNode& tr, LPCSTR lpcszTitle, LPCSTR lpcszDescription, PEVENT_GETN pGetNEvent, PAPPLY_FUNC pfn = NULL, PEVENT_FUNC pEvtFn = NULL);
	
	DynaBoxDlg myDlg(nID, tr, lpcszTitle, lpcszDescription, NULL, pfn, pEvtFn);
	int nRet = myDlg.DoModalEx(hWndParent);
	if(IDOK == nRet)
	{
		myDlg.UpdateEditTreeNode(tr);
		return true;
	}
	return false;  
}

////----- AW 10/02/06 QA80-9015 v8.0493 MORE_ON_ASCII_OPTION 
int DynaBox3(TreeNode& tr, LPCSTR lpcszTitle, LPCSTR lpcszTextOK, LPCSTR lpcszTextApply, LPCSTR lpcszDescription, PEVENT_FUNC pEvtFn, HWND hWndParent) //=NULL,NULL,NULL, NULL, NULL
{
	int nID;
	int nThemeType;
	///Joseph 04/03/07 CHANGE_PARAMETER_SHOULD_NOT_SUPPORT_THEME_AND_AUTOUPDATE_MODE
	/*
	//Jasmine 02/02/07 QA70-9336 FIX_XF_NO_THEME_BUG
	//if( is_xf_gui_getn_tree(tr) || tr.tagName == "GUI")
	if( (is_xf_gui_getn_tree(tr) && tr.tagName.CompareNoCase(XFGUI_GETN_TAGNAME_NO_THEME) )|| tr.tagName == "GUI")
		nID = IDD_DYNABOX_THEME;
	else
		nID = IDD_DYNABOX;
	*/
	nID = _get_dynabox_resource_id(tr);
	///End CHANGE_PARAMETER_SHOULD_NOT_SUPPORT_THEME_AND_AUTOUPDATE_MODE
//	DynaBoxDlg(int nID, TreeNode& tr, LPCSTR lpcszTitle, LPCSTR lpcszDescription, PEVENT_GETN pGetNEvent, PAPPLY_FUNC pfn = NULL, PEVENT_FUNC pEvtFn = NULL);
	
	DynaBoxDlg myDlg(nID, tr, lpcszTitle, lpcszDescription, NULL, NULL, pEvtFn);
	myDlg.SetButtonText(lpcszTextOK, lpcszTextApply);
	int nRet = myDlg.DoModalEx(hWndParent);
	if(IDCANCEL != nRet)
	{
		myDlg.UpdateEditTreeNode(tr);
	}
	return nRet;
}
////----- END MORE_ON_ASCII_OPTION 

//	DynaBoxDlg(int nID, TreeNode& tr, LPCSTR lpcszTitle, LPCSTR lpcszDescription, PEVENT_GETN pGetNEvent, PAPPLY_FUNC pfn = NULL, PEVENT_FUNC pEvtFn = NULL);
//use pGetNEvent on press apply button 
///Joseph 01/29/07 GETN_BOX_ADD_APPLY_BUTTON
//DynaBoxDlg::DynaBoxDlg(int nID, TreeNode& tr, LPCSTR lpcszTitle, LPCSTR lpcszDescription, PEVENT_GETN pGetNEvent, PAPPLY_FUNC pfn, PEVENT_FUNC pEvtFn) : DynaDlg(nID, tr, "ODlg")
DynaBoxDlg::DynaBoxDlg(int nID, TreeNode& tr, LPCSTR lpcszTitle, LPCSTR lpcszDescription, PEVENT_GETN pGetNEvent, PAPPLY_FUNC pfn, PEVENT_FUNC pEvtFn, bool bShowApply) : DynaDlg(nID, tr, "ODlg8")
///End GETN_BOX_ADD_APPLY_BUTTON
{
	m_pEventNew = pGetNEvent;//------ CPY 7/3/06 QA70-8798 DYNABOX_BETTER_EVENTS
	m_pApplyFunc = pfn;
	m_pEventFunc = pEvtFn;
	m_bApply1stTime = true;
	
	m_strTitle = lpcszTitle;
	m_strDescription = lpcszDescription;
		
	m_bUseTryForApply = false;
	//---  CPY 5/22/03 v7.0589 SHIFT_SHOW_FOR_CLASSES
	tr.GetAttribute(STR_CLASS_NAME, m_strClassName);
	//---
	m_nDlgID = nID; 
	//m_bIsFlatDialogDisplay = IDD_GET_N_BOX == nID? true:false;
	
	//--- CPY 6-30-06 QA70-8792 GETN_RESIZING_FROM_ATTRIBUTE
	m_bAllowResizing = false;
	string strResizeInfo;
	if(tr.GetAttribute(STR_RESIZE_DIALOG, strResizeInfo))
	{
		m_bAllowResizing = true;
		//strResizeInfo = "cx|cy|name";
		// first check if name is in registry, if yes, load the cx,cy from it, otherwise use the cxcy
	}
	//---
	////----- AW 10/02/06 QA80-9015 v8.0493 MORE_ON_ASCII_OPTION
	m_strbnOKText.Empty();
	m_strbnApplyText.Empty();
	//m_bApplyBtnExit = false;
	m_nButtonExitEventID = 0;
	////----- END MORE_ON_ASCII_OPTION
	
	///Joseph 04/27/06 FIX_BUG_ON_APPLY_BUTTON
	//should support xf apply button, bShowApply = false
	//but show the apply button by STR_CUSTOM_BUTTONS_ATTRIB attribute
	//m_bShowApplyGetNEvent = bShowApply;	///Joseph 01/29/07 GETN_BOX_ADD_APPLY_BUTTON
	/// Iris 10/28/2008 QA80-12479 FIX_CANNOT_SHOW_APPLY_BTN_IN_SIMPLE_GETN
	// Discussed with Sim, cannot use strCustomButtons.Find("Apply") >= 0 to decide if show Apply since GETNEVENT_ON_INIT will change this attribute and ShowCustomButton will change buttons show 
	/*
	string strCustomButtons;
	tr.GetAttribute(STR_CUSTOM_BUTTONS_ATTRIB, strCustomButtons);
	if(strCustomButtons.Find("Apply") >= 0 || bShowApply)
		m_bShowApplyGetNEvent = true;
	else
		m_bShowApplyGetNEvent = false;
	*/
	m_bShowApply = bShowApply;
	///End FIX_BUG_ON_APPLY_BUTTON
		
	SetContainerTitle(lpcszTitle);	///Kenny 04/09/2009 QA80-13422 COUNT_APPEAR_TIMES_OF_ERR_MSG
}
	
	//int DoModalEx(HWND hWndParent = NULL)
int DynaBoxDlg::DoModalEx(HWND hWndParent)
{
	//m_bApplyBtnExit = false;		////----- AW 10/02/06 QA80-9015 v8.0493 MORE_ON_ASCII_OPTION
	m_nButtonExitEventID = 0;
	DWORD dwDlgOptions = preCreateGetNBoxDlg(hWndParent);

	int nRet = DoModal(hWndParent, dwDlgOptions);
	////----- AW 10/02/06 QA80-9015 v8.0493 MORE_ON_ASCII_OPTION
//----------- CPY 2/19/07 CUSTOM_APPLY_BUTTONS_CLEANUP
//	if ( m_bApplyBtnExit )
//		nRet = IDC_APPLY;
	CheckSpecialExit(nRet);
//-----------
	////----- END MORE_ON_ASCII_OPTION
	if(nRet != IDCANCEL )
	{
		UpdateInputTree();			
	//--- CPY 7/1/06 REMOVE_SHIFT_SHOW_CHECK
	//	updateShiftShowStatus();
	//---
		saveDefaultGUI();
	}
	return nRet;
}
DWORD 	DynaBoxDlg::preCreateGetNBoxDlg(HWND hWndParent)
{
	InitMsgMap();
	
	DWORD dwDlgOptions = 0;
	if(hWndParent)
		dwDlgOptions |= DLG_NO_DEFAULT_REPOSITION;
			
	return dwDlgOptions;
	
}
//int CreateEx(HWND hWndParent = NULL)
int DynaBoxDlg::CreateEx(HWND hWndParent)
{
	DWORD dwDlgOptions = preCreateGetNBoxDlg(hWndParent);
	return Create(hWndParent, dwDlgOptions);
}
	

//#define THE_GRID MyDlg.GetItem(IDC_PARAMS_GRID).GetActiveXControl()
//protected: ///MOVE_DECLARATION_TO_HEADER
	
///Iris 9/15/04 MOVE_DECLARATION_TO_HEADER
//EVENTS_BEGIN
/// TD 5-26-06 QA70-8428 EDITBOX_WITH_BUTTON
//BEGIN_MESSAGE_MAP(DynaBoxDlg)
BEGIN_MESSAGE_MAP_DERIV(DynaBoxDlg, DynaDlg)
/// end EDITBOX_WITH_BUTTON
	ON_INIT(OnInitDialog)
	ON_READY(OnReady)
	ON_DESTROY(OnDestroy)
	ON_BN_CLICKED(IDC_APPLY, OnApplyButton)
	ON_BN_CLICKED(IDC_UNDO_BTN, OnUndoButton) ///---Sim 07-27-2007 IMPLEMENT_APPLY_AND_UNDO_MECHANISM
	ON_GETNDLG_MSGS(IDC_PARAMS_GRID)
	ON_SIZE(OnDlgResize)
	ON_RESTORESIZE(OnRestoreSize) //----- CPY 5/28/2007 QA70-9839 GETNBOX_BETTER_POSITION_CNTRL
	//--- CPY 7/5/06 QA70-8798 ON_OK_EVENT_TO_ALLOW_XF_HANDLING
	ON_OK(OnOK) 
	ON_USER_MSG(WM_USER_MSG_BOX, OnMsgBox)
	ON_USER_MSG(WM_USER_MSG_ON_DLG, OnDynamicMsg)//---- CPY 10/26/06 QA70-9063 DYNAMIC_ERR_MSG_IN_GETN_DIALOGS
	ON_USER_MSG(WM_USER_TREEEDITOR_VALUE_CHANGE, OnAfterValueChange)   ///Joseph	12/07/06	ADD_ERROR_MSGBOX
//	ON_USER_MSG(WM_USER_RESIZE_CONTROLS, OnInternalResize)	//----- CPY 10/29/06 QA70-9063 DYNAMIC_ERR_MSG_IN_GETN_DIALOGS_SMART_HEIGHT
	//---
	
	///Danice GETNBOX_SAME_AS_GETNVIEWBOX
	/*
	ON_EVENT(EN_SETFOCUS, IDC_PARAMS_GRID, OnSetFocus)
	ON_USER_MSG(WM_USER_ON_CHILD_KILL_FOCUS, OnEditorKillFocus)
	ON_USER_MSG(WM_USER_RECONSTRUCT, OnReconstructGrid)
	//ON_SIZE(OnResize)
	ON_GRID_BEFORE_EDIT(IDC_PARAMS_GRID, OnBeforeEdit)
	ON_GRID_VALIDATE_EDIT(IDC_PARAMS_GRID, OnValidateEdit)
	ON_GRID_AFTER_EDIT(IDC_PARAMS_GRID, OnAfterEdit)
	ON_GRID_ROW_COL_CHANGE(IDC_PARAMS_GRID, OnRowColChange)
	ON_GRID_COMBO_CLOSEUP(IDC_PARAMS_GRID, OnComboCloseUp)
	ON_GRID_BEFORE_MOUSE_DOWN(IDC_PARAMS_GRID, OnBeforeMouseDown)
	ON_GRID_DRAW_CELL(IDC_PARAMS_GRID, OnDrawCell)
	ON_GRID_BUTTON_CLICK(IDC_PARAMS_GRID, OnButtonClick)
	*/
	///END GETNBOX_SAME_AS_GETNVIEWBOX
	/// ML 2/14/2006 NEW_TREECONTROL_FOR_GetNBoxDlg
	//ON_GRID_AFTER_COLLAPSE(IDC_PARAMS_GRID, OnAfterCollapse)
	/// end NEW_TREECONTROL_FOR_GetNBoxDlg
	
	ON_CLICK_KEY(OnKey) //CPY 6/11/03 QA70-4450 v7.0601 TTILE_KEY_TO_BECOME_MODLESS

	ON_HELPINFO(OnHelp) //CPY 10/11/03 QA70-5332 HELP_CUSTOMIZED
	
	///Danice GETNBOX_SAME_AS_GETNVIEWBOX
	/*
	///////////// Range Control related ////////////
	ON_SLIDE_BEFORE(IDC_PARAMS_RANGE_SLIDER, OnRangeSlide)
	ON_EVENT(EN_SETFOCUS, IDC_PARAMS_X_FROM, OnSetFocusFrom)
	ON_EVENT(EN_SETFOCUS, IDC_PARAMS_X_TO, OnSetFocusTo)
	ON_EVENT(EN_KILLFOCUS, IDC_PARAMS_X_FROM, OnKillFocusFrom)
	ON_EVENT(EN_KILLFOCUS, IDC_PARAMS_X_TO, OnKillFocusTo)
	ON_BN_CLICKED(IDC_PARAMS_RANGE_FULL, OnFullRange)
	///////////// end Range Control related ////////////
	*/
	///END GETNBOX_SAME_AS_GETNVIEWBOX
#if _OC_VER >= 0x0800
//	ON_CHANGE_SELECTION(OnSelectionChange)
//	ON_SELECTION_TRACK(OnSelectionTrack)
//	ON_DS_SELECTION_TRACK(OnDSSelectionTrack)
//	ON_DS_SELECTION_CHANGE(OnDSSelectionChange)
	/// ML 2/14/2006 NEW_TREECONTROL_FOR_GetNBoxDlg
	///// YuI 01/03/2005 v7.5183 QA70-7253 VECTORIAL_NUMERIC_FUNCTIONS
	//ON_BN_CLICKED(IDC_DATARANGE_DLG_BUTTON, OnInteractiveDataRange)
	//ON_BN_CLICKED(IDC_XY_DATARANGE_DLG_BUTTON, OnInteractiveXYDataRange)
	//ON_BN_CLICKED(IDC_DATA_SELECT_POPUP_BTN,  OnInteractivePopUp)
	///// end VECTORIAL_NUMERIC_FUNCTIONS
	/// end NEW_TREECONTROL_FOR_GetNBoxDlg
	ON_CBN_SELCHANGE(IDC_PARAMS_THEME, OnComboChangeTheme)  //------ CPY 9/12/04 QA70-6682 GETN_THEME_SAVEAS_NEW_DIALOG
	///Forest 9/13/04 QA70-6682 GETN_THEME_SAVEAS_NEW_DIALOG
	ON_BN_CLICKED(IDC_PARAMS_SAVE, OnSaveTheme)
	ON_BN_CLICKED(IDC_PARAMS_SAVE_AS, OnSaveThemeAs)
	///End GETN_THEME_SAVEAS_NEW_DIALOG
	ON_BN_CLICKED(IDC_PARAMS_SHOW_ADVANCED, OnShowAdvancedCheck) //---- CPY 12/23/04 QA70-7273 ADD_SHOW_ADVANCED_CHECK_BOX

	ON_USER_MSG(WM_USER_DYNACTRL_EXPAND_COLLAPSE, OnAfterExpandCollapse)
	ON_USER_MSG(WM_USER_ON_GRAPH_OBJECT_CHANGE, InvokeGlobalEventOnGraphObjectChange)
	
	///Joseph 02/05/07 DYNABOX_DLG_NEED_MORE_BTNS
	ON_BN_CLICKED(IDC_GETN_CUSTOM_BTN1, OnClickCustomButtom)
	ON_BN_CLICKED(IDC_GETN_CUSTOM_BTN2, OnClickCustomButtom)
	ON_BN_CLICKED(IDC_GETN_CUSTOM_BTN3, OnClickCustomButtom)
	ON_BN_CLICKED(IDC_GETN_CUSTOM_BTN4, OnClickCustomButtom)
	///End DYNABOX_DLG_NEED_MORE_BTNS
#endif //if _OC_VER >= 0x0800
//EVENTS_END  ///Iris 9/15/04 MOVE_DECLARATION_TO_HEADER
/// TD 5-26-06 QA70-8428 EDITBOX_WITH_BUTTON
//END_MESSAGE_MAP 
END_MESSAGE_MAP_DERIV     
/// end EDITBOX_WITH_BUTTON
// TD 6-30-06 QA70-8792  ALLOW_RESIZING
#define DS_MODALFRAME       0x80L   /* Can be combined with WS_CAPTION  */
void DynaBoxDlg::AllowResizing(BOOL bResizing)// = TRUE
{
	if(bResizing)
		return; // default, res is to allow resizing
	
	int nStyleCurrent = GetWindowLong(Window::GetSafeHwnd(), GWL_STYLE);
	if(bResizing)
	{
		nStyleCurrent |= WS_THICKFRAME;
	}
	else
	{
		nStyleCurrent &= (~WS_THICKFRAME);
	}
	SetWindowLong(Window::GetSafeHwnd(), GWL_STYLE, nStyleCurrent);
}
// end ALLOW_RESIZING

//------------ Event Handlers ------------------------

//----- CPY 5/28/2007 QA70-9839 GETNBOX_BETTER_POSITION_CNTRL
BOOL DynaBoxDlg::OnRestoreSize(DWORD dwSizeInfo)
{
	void * p = (void*)dwSizeInfo;
	DLGSIZEINFO *pSz = (DLGSIZEINFO*)p;
	lstrcpyn(pSz->szDialogName, m_strClassName, MAXLINE);
	//-1,0,0,0 to indicate position remembering only
	pSz->top = -1;
	pSz->width = pSz->height = pSz->left =0;
	return true;
}
//-----

/// Iris 10/28/2008 QA80-12479 FIX_CANNOT_SHOW_APPLY_BTN_IN_SIMPLE_GETN
// introduce isApplyButtonShow() to replace m_bShowApplyGetNEvent since m_bShowApplyGetNEvent is not a good name for understanding.
bool DynaBoxDlg::isApplyButtonShow()
{
	Button cApplyBtn = GetItem(IDC_APPLY);
	if( cApplyBtn && cApplyBtn.Visible )
		return true;
	return false;
}
///end FIX_CANNOT_SHOW_APPLY_BTN_IN_SIMPLE_GETN

BOOL DynaBoxDlg::OnInitDialog()
{
	// TD 6-30-06 QA70-8792  ALLOW_RESIZING
	AllowResizing(m_bAllowResizing);
	// end ALLOW_RESIZING
	waitCursor junk;
	//Profiler jj;
	TreeNode tr = GetTree();
	//----- CPY 5/28/2007 QA70-9839 GETNBOX_BETTER_POSITION_CNTRL
	//ResizeDialog::OnInitDialog();
	ResizeDialog::OnInitDialog(0, m_strClassName);
	//----

	//------ Folger 03/03/08 QA80-11192 ADD_THEME_CONTROL_POPUP_MENU
#ifndef THEME_CONTROL_POPUP_MENU
	//--------Folger 07/20/07 USE_BITMAP_RADIO_BUTTON_INSTEAD_OF_TEXT_BUTTON
	if (m_nDlgID == IDD_DYNABOX_THEME)
	{
		BitmapRadioButton m_btnSave = GetItem(IDC_PARAMS_SAVE);
		vector<string> vsTips;
		vsTips.Add(_L("Save theme"));
		m_btnSave.Init(1, IDB_PAGEXFBAR_SAVE, 16, vsTips);
		
		BitmapRadioButton m_btnSaveAs = GetItem(IDC_PARAMS_SAVE_AS);	
		vsTips.RemoveAll();
		vsTips.Add(_L("Save theme as..."));
		m_btnSaveAs.Init(1, IDB_PAGEXFBAR_SAVEAS, 16, vsTips, NULL);
	}
	//--------End USE_BITMAP_RADIO_BUTTON_INSTEAD_OF_TEXT_BUTTON	
#else
	if ( m_nDlgID == IDD_DYNABOX_THEME )
	{
		BitmapRadioButton m_btnSaveAs = GetItem(IDC_PARAMS_SAVE_AS);
		vector<string> vsTips;
		m_btnSaveAs.Init(1, IDB_DROP_DOWN_UP, 16, vsTips);
	}
#endif
	//------ End ADD_THEME_CONTROL_POPUP_MENU
	
	//--- CPY 7/1/06 REMOVE_SHIFT_SHOW_CHECK
	//m_chkShiftShow = GetItem(IDC_PARAMS_SHIFTSHOW);
	//---
	m_chkAdvanced = GetItem(IDC_PARAMS_SHOW_ADVANCED); 
	if(m_chkAdvanced)
	{
		//--- Iris 11/10/06 HIDE_SHOWADVAN_BOX from Easwar's suggestion
		/*
		bool 	bShow = true;
		string 	strName = tr.tagName;
		if( 0 == strName.Compare("XFGUI") )
			bShow = false;
		*/
		bool	bShow = isShowAdvancedBox(tr);
		//--- 
		m_chkAdvanced.Visible = bShow;
		
		m_chkAdvanced.Check = isShowAdvanced(tr); ///Get show advanced from TreeNode attribute STR_SHOW_ADVANCED_ATTRIB		
		/// Iris 9/4/2009 QA80-14165-P2 FIX_STATS_ON_COL_NOT_PRO_TIP_WHEN_CHANGE_PARAM
		//update_param_tree_advanced_ids(tr, isShowAdvanced()); 
		///end FIX_STATS_ON_COL_NOT_PRO_TIP_WHEN_CHANGE_PARAM
	}
	/// Iris 9/4/2009 QA80-14165-P2 FIX_STATS_ON_COL_NOT_PRO_TIP_WHEN_CHANGE_PARAM
	update_param_tree_advanced_ids(tr, isShowAdvanced());
	/// End FIX_STATS_ON_COL_NOT_PRO_TIP_WHEN_CHANGE_PARAM

	InitThemeControls(this, tr, IDC_PARAMS_THEME, IDC_PARAMS_THEME_LABEL, IDC_PARAMS_SAVE, IDC_PARAMS_SAVE_AS, IDC_PARAMS_DESCRIPTION, IDC_PARAMS_DESCRIPTION_LABEL);//------ CPY 5/20/06 THEME_COMBO_IN_BASE_CLASS
//--- CPY 7/1/06 REMOVE_SHIFT_SHOW_CHECK
//	int nIsShiftShow = getShiftShowStatus();
//	if(nIsShiftShow >= 0)
//	{
//		m_chkShiftShow.Visible = true;
//		m_chkShiftShow.Check = nIsShiftShow;
//	}

	int nSubBranchs = 0;
	tree_count_items(tr, &nSubBranchs);
	PEVENT_GETN pfnNew = GetNewEventHandler();
	PEVENT_FUNC pfn = GetOldEventHandler();
	if(InitDynaControl(IDC_PARAMS_GRID))
		SetEventCallback(pfn, pfnNew);
	
	///---Joseph 03/31/06 NOT_USE_THEME_DESCRIPTION_ANY_MORE
	/*
	int nCaptionID = 0;
	Control cCaption = GetItem(IDC_PARAMS_DESCRIPTION);
	if(!m_strDescription.IsEmpty())
	{
		nCaptionID = IDC_PARAMS_DESCRIPTION;
		cCaption.Text = m_strDescription;
		cCaption.Visible = true;
	}
	else
	{
		cCaption.Text = "";	///Joseph 03/16/07 FIX_BUG_ON_WHIHOUT_THEME_GETN_BOX
		cCaption.Visible = false;
	}
	*/
	
	if(m_strDescription.IsEmpty())
	{	
		Control cCaption = GetItem(IDC_PARAMS_DESCRIPTION);
		cCaption.Text = "";	///Joseph 03/16/07 FIX_BUG_ON_WHIHOUT_THEME_GETN_BOX
	}
	///---End NOT_USE_THEME_DESCRIPTION_ANY_MORE
	
	///---Sim 07-27-2007 FIX_POS_OF_APPLY_UNDO_BTN_FOR_XF_DLG
	Button cUndoBtn = GetItem(IDC_UNDO_BTN);
	if(cUndoBtn) //CPY 7/26/2007 RUNTIME_ERR_WHEN_USING_UPDATE_LEGEND_XF
	{
		cUndoBtn.Visible = false;
		m_bRepeatingApply = true;
	}
	///---END FIX_POS_OF_APPLY_UNDO_BTN_FOR_XF_DLG
	
	Button cApplyBtn = GetItem(IDC_APPLY);
	////----- AW 10/02/06 QA80-9015 v8.0493 MORE_ON_ASCII_OPTION
	Button cOKBtn = GetItem(IDOK);
	if ( !m_strbnOKText.IsEmpty() )
	{
		cOKBtn.Text = m_strbnOKText;
	}
	bool bUserApplyButtonText = false; //---CPY 10/27/06 ASCII_OPTN_DLG_UPDATE_BUTTON_DISABLED
	if ( !m_strbnApplyText.IsEmpty() )
	{
		cApplyBtn.Text = m_strbnApplyText;
		bUserApplyButtonText = true;
	}
	////----- END MORE_ON_ASCII_OPTION	
	//---------- CPY 10/26/06 QA70-9063 DYNAMIC_ERR_MSG_IN_GETN_DIALOGS
	//m_btnErrMessage = GetItem(IDC_ERR_MESSAGE_BOX);//--- Iris 10/24/06 ADD_ERR_MESSAGE_LINE
	//m_btnErrMessage.Text = "";
	//----
	
	m_bUseTryForApply = false;
	if(m_pApplyFunc)
	{
		string strApplyButtonText;
		if(tr.GetAttribute(STR_OPERATION_TRY, strApplyButtonText))
		{
			m_bUseTryForApply = true;
			cApplyBtn.Text = strApplyButtonText;
		}
	}
	else
	{
		if ( m_strbnApplyText.IsEmpty() )  ////----- AW 10/02/06 QA80-9015 v8.0493 MORE_ON_ASCII_OPTION
			cApplyBtn.Visible = false;
	}
	
	//UpdateDynaControl(true, GETNEVENT_ON_INIT, true); ///---Sim 07-27-2007 IMPLEMENT_APPLY_AND_UNDO_MECHANISM remove
	
	/// YuI 02/22/08 QA80-11156 DEFAULT_XF_APPLY_BUTTON_IMPLEMENTATION
	/*
	//------- CPY 10/27/06 ASCII_OPTN_DLG_UPDATE_BUTTON_DISABLED
	//enableButton(IDC_APPLY, m_pApplyFunc? true:false);
	if(m_pApplyFunc || bUserApplyButtonText)
		enableButton(IDC_APPLY, true);
	else
		enableButton(IDC_APPLY, false);
	//---
	*/
	// always enable - Apply button and let event handler disable
	enableButton(IDC_APPLY, true);
	/// end DEFAULT_XF_APPLY_BUTTON_IMPLEMENTATION
	
	/// Iris 10/28/2008 QA80-12479 FIX_CANNOT_SHOW_APPLY_BTN_IN_SIMPLE_GETN, should check apply button show after ShowCustomButton below
	/////Joseph 01/29/07 GETN_BOX_ADD_APPLY_BUTTON
	//if(pfnNew && m_bShowApplyGetNEvent)
	//{
		//cApplyBtn.Visible = true;
		//enableButton(IDC_APPLY, true);
	//}
	/////End GETN_BOX_ADD_APPLY_BUTTON
	///end FIX_CANNOT_SHOW_APPLY_BTN_IN_SIMPLE_GETN
		
	///---Sim 07-27-2007 FIX_POS_OF_APPLY_UNDO_BTN_FOR_XF_DLG
	if ( m_dwXFBits & DYNALAYOUT_CONTROL_APPLY_UNDO_BTN_STATUS_SEPARATELY )
	{
		enableButton(IDC_UNDO_BTN, true);
	}
	else
	{
		enableButton(IDC_UNDO_BTN, false);
	}
	///---END FIX_POS_OF_APPLY_UNDO_BTN_FOR_XF_DLG

	///------ Folger 03/08/10 QA81-15177 GETNBOX_SUPPORT_MOVE_FIRST_LEVEL_BRANCHES_INTO_TABS
	//UpdateDynaControl(true, GETNEVENT_ON_INIT, true); ///---Sim 07-27-2007 IMPLEMENT_APPLY_AND_UNDO_MECHANISM
	InitTabControl();

	UpdateDynaControl(true, GETNEVENT_ON_INIT, true, 0, true, GetDisplaySubnodeInitialIndex());
	///------ End GETNBOX_SUPPORT_MOVE_FIRST_LEVEL_BRANCHES_INTO_TABS
	
	ShowCustomButton();	///Joseph 02/05/07 DYNABOX_DLG_NEED_MORE_BTNS	
	
	/// Iris 10/28/2008 QA80-12479 FIX_CANNOT_SHOW_APPLY_BTN_IN_SIMPLE_GETN
	string strCustomButtons;
	if( m_bShowApply )
		cApplyBtn.Visible = true;
	///end FIX_CANNOT_SHOW_APPLY_BTN_IN_SIMPLE_GETN
	
	///---Sim 07-27-2007 IMPLEMENT_APPLY_AND_UNDO_MECHANISM
	/// Iris 10/28/2008 QA80-12479 FIX_CANNOT_SHOW_APPLY_BTN_IN_SIMPLE_GETN
	//if ( cApplyBtn && cApplyBtn.Visible )
	//	m_bShowApplyGetNEvent = true;
	///end FIX_CANNOT_SHOW_APPLY_BTN_IN_SIMPLE_GETN
	
	if ( cUndoBtn && cUndoBtn.Visible )
		m_bRepeatingApply = false;
	
	// special init apply and undo button for simple getn box
	/// Iris 10/28/2008 QA80-12479 FIX_CANNOT_SHOW_APPLY_BTN_IN_SIMPLE_GETN
	//if ( m_bShowApplyGetNEvent && !m_bRepeatingApply && !(m_dwXFBits & DYNALAYOUT_CONTROL_APPLY_UNDO_BTN_STATUS_SEPARATELY) )
	if ( isApplyButtonShow() && !m_bRepeatingApply && !(m_dwXFBits & DYNALAYOUT_CONTROL_APPLY_UNDO_BTN_STATUS_SEPARATELY) )
	///end FIX_CANNOT_SHOW_APPLY_BTN_IN_SIMPLE_GETN
	{
		enableButton(IDC_APPLY, true);
		enableButton(IDC_UNDO_BTN, false);
	}
	///---END IMPLEMENT_APPLY_AND_UNDO_MECHANISM

	/// Folger 11/10/09 empty title in GetN should be allowed.
	//if(!m_strTitle.IsEmpty())
		m_wndDlg.Text = m_strTitle;
	
	tr.GetAttribute(STR_ATTRIB_MAX_HEIGHT_WIDTH, m_strMaxHeightWidth);
	
	///Cheney 2006-9-22 MOVE_BRANCH_LOADING_AND_SAVING_FROM_DYNABOX_TO_DYNADLG
	////---Cheney 2006-07-26 IF_NO_DIALOG_TITLE_NOT_LOAD_AND_SAVE
	////---Cheney 2006-06-21 QA70-8740 SAVING_BRANCH_IN_OPERATION_BASED_DIALOG
	//if(m_strTitle != "")
	//{
		//string strBranchSetting;
		//if( dlg_load_registry(m_strTitle, "Branch Setting", strBranchSetting))
		//{
			//BitsHex bh;
			//vector<byte> vbBranchSetting;
			//if(!bh.HexStrToBits(strBranchSetting, vbBranchSetting))
				//return false;
			//
			//if(!m_DynaCntrl.SetCollapsed(vbBranchSetting, FALSE))
				//return false;
		//}
	//}
	////---end IF_NO_DIALOG_TITLE_NOT_LOAD_AND_SAVE
	//UpdateDynaControl();
	////---end SAVING_BRANCH_IN_OPERATION_BASED_DIALOG
	LoadBranchSetting();
	UpdateDynaControl();
	///end MOVE_BRANCH_LOADING_AND_SAVING_FROM_DYNABOX_TO_DYNADLG
	
	resizeDlgToFit();	
	
	/// Iris 12/27/2006 v8.0533 CALL_EVENT1_ON_GRAPH_OBJ_MOVING
	/// Iris 01/04/2007 v8.0536 FIX_AFTER_SAVEAS_THEME_MOVE_GRAPH_OBJ_FAIL_TO_ENTER_EVENT1
	/*
	HWND 	hwnd = GetSafeHwnd();
	post_getn_dialog_message(PGDM_SET_HDLG, (uint)hwnd);
	*/
	Page pg = Project.Pages();
	PostMessageOnObjectChange(true, pg);
	///end FIX_AFTER_SAVEAS_THEME_MOVE_GRAPH_OBJ_FAIL_TO_ENTER_EVENT1
	///end CALL_EVENT1_ON_GRAPH_OBJ_MOVING
	
	///---Sim 11-13-2009 QA81-14623 NOT_CLOSE_DLG_WHEN_ENTER_PRESSED
	if ( DYNALAYOUT_NOT_CLOSE_ON_ENTER_KEY & m_dwXFBits )
		SetDefaultButton(FALSE);
	///---END QA81-14623 NOT_CLOSE_DLG_WHEN_ENTER_PRESSED
	
	return true;
}

//---- CPY 7/3/06 QA70-8798 DYNABOX_BETTER_EVENTS
//virtual 
///Joseph 02/25/06 DO_NOT_ENABLE_BUTTON_ON_SOME_EVENTS
//void DynaBoxDlg::OnEnableButtons(DWORD dwEnable)//OK and Apply buttons
void DynaBoxDlg::OnEnableButtons(DWORD dwEnable, int nEventID)//OK and Apply buttons
///End DO_NOT_ENABLE_BUTTON_ON_SOME_EVENTS
{
	///---Sim 07-27-2007 IMPLEMENT_APPLY_AND_UNDO_MECHANISM
	/*
	uint nBtnIds[] = {
		IDC_APPLY,
		IDOK,
		0};
	*/
	///---END IMPLEMENT_APPLY_AND_UNDO_MECHANISM
	
	///Joseph 02/05/07 DYNABOX_DLG_NEED_MORE_BTNS 
	//EnableControls(nBtnIds, bEnable);
	BOOL bEnable = dwEnable & GETNGEVT_OK_ENABLE;
	///---Sim 07-27-2007 IMPLEMENT_APPLY_AND_UNDO_MECHANISM
	//EnableControls(nBtnIds, bEnable);	
	if ( m_dwXFBits & DYNALAYOUT_CONTROL_APPLY_UNDO_BTN_STATUS_SEPARATELY )
	{	// user contorl apply and undo button
		enableButton(IDC_APPLY, (dwEnable & GETNGEVT_APPLY_ENABLE)); 
		enableButton(IDC_UNDO_BTN, (dwEnable & GETNGEVT_UNDO_ENABLE)); 
	}
	else 
	{	// framework contorl apply and undo button
		if ( GETNE_ON_INIT != nEventID )
		{
			if ( m_bRepeatingApply )
			{
				enableButton(IDC_APPLY, bEnable); 
			}
			else
			{
				if ( GETNE_ON_APPLY == nEventID )
				{
					enableButton(IDC_APPLY, false); 
					enableButton(IDC_UNDO_BTN, true); 
				}
				if ( GETNE_ON_UNDO == nEventID )
				{
					enableButton(IDC_APPLY, true); 
					enableButton(IDC_UNDO_BTN, false); 
				}
			}
		}
	}
	enableButton(IDOK, bEnable);
	///---END IMPLEMENT_APPLY_AND_UNDO_MECHANISM
	EnableCustomButtons(dwEnable);	
	///End DYNABOX_DLG_NEED_MORE_BTNS
}
//----

/// YuI 04/17/06 GLOBAL_EVENT_HANDLER_NEEDS_TO_BE_INVOKED
void 	DynaBoxDlg::InvokeGlobalEventOnInitDialog()
{
	// this code is taken from GetNBoxDlg::OnInitDialog
	// TD 5-2-06
	//moved to base class
	//PEVENT_FUNC pfn = getEventHandler();
	//if(pfn)
	//{
	//	int nCntrlTypes[] = {
	//		ONODETYPE_CHECKBOX,
	//		ONODETYPE_DROPDOWN_NUMERIC_FLOAT,
	//		ONODETYPE_DROPLIST_STRINGS,
	//		ONODETYPE_DROPLIST_COLORS,
	//		0
	//	};
	//	int ii = 0;			
	//	while(nCntrlTypes[ii] > 0)
	//	{
	//		pfn(GetTree(), -1, nCntrlTypes[ii], *this);
	//		ii++;
	//	}
	//}
	/// CPY Iris 7/20/06 v8.0447 SEPRATE_INIT_AND_THEME_EVENT
	//invokeBasicGlobalEventOnInitDialog();
	invokeBasicGlobalEvent(GETNE_ON_INIT);
	///end SEPRATE_INIT_AND_THEME_EVENT
	//----
}
/// end GLOBAL_EVENT_HANDLER_NEEDS_TO_BE_INVOKED

///Sandy 2007-4-2 MOVE_GRAPH_OBJECT_EVENT_TO_BASE_CLASS
/// Iris 12/28/2006 v8.0533 CALL_EVENT1_ON_GRAPH_OBJ_MOVING
//BOOL 	DynaBoxDlg::InvokeGlobalEventOnGraphObjectChange(uint wParam, uint lParam)
//{
	//TreeNode tr = GetTree();
	//if(tr)
	//{
		//tr.SetAttribute(STR_GO_MSG_INFO_1_ATTRIB, (int)wParam);
		//tr.SetAttribute(STR_GO_MSG_INFO_2_ATTRIB, (int)lParam);
	//}
	//invokeBasicGlobalEvent(GETNE_ON_GRAPH_OBJECT_CHANGE);
	//return true;
//}
/// end CALL_EVENT1_ON_GRAPH_OBJ_MOVING
///end MOVE_GRAPH_OBJECT_EVENT_TO_BASE_CLASS

/// CPY Iris 7/20/06 v8.0447 SEPRATE_INIT_AND_THEME_EVENT
//virtual 
void 	DynaBoxDlg::InvokeGlobalEventOnThemeChange()
{
	invokeBasicGlobalEvent(GETNE_ON_THEME);
}
///end SEPRATE_INIT_AND_THEME_EVENT
//---- CPY 10/20/05 
BOOL DynaBoxDlg::OnReady()	
{
	//resizeDlgToFit();
	//PostDlgMessage(WM_USER_RECONSTRUCT, GRID_CHANGE_SIZE | GRID_CHANGE_SKIP_HANDLERS_ON_UPDATE);
//	TreeEditDlg::OnReconstructGrid(GRID_CHANGE_SIZE | GRID_CHANGE_SKIP_HANDLERS_ON_UPDATE, 0);

	SetInitReady();		//------ Folger 11/27/07 FIX_REFRESH_BUG_IN_GETNBOX
	resizeDlgToFit(); //--- CPY 2/24/2007 XF_SIMPLE_GETN_DLG_NOT_INIT_RESIZED, not sure who removed this, just put back now

	return true;
}
//----
//virtual 
void DynaBoxDlg::ResizeDlgControls()//CPY 10/29/06 QA70-9063 DYNAMIC_ERR_MSG_IN_GETN_DIALOGS_SMART_HEIGHT	
{
	resizeDlgToFit();
	//	PostMessage(WM_USER_RESIZE_CONTROLS);
}
/*
BOOL DynaBoxDlg::OnInternalResize(uint wParam, uint lParam)
{
	resizeDlgToFit();
	return true;
}
*/
BOOL DynaBoxDlg::OnDlgResize(int nType, int cx, int cy)
{
	if(!IsInitReady())
		return TRUE;
	
	MoveControlsHelper	_temp(this);		//------ Folger 11/27/07 FIX_REFRESH_BUG_IN_GETNBOX
	
	resizeDlgToFit(cx, cy);//---- CPY 6-30-06 QA70-8792 GETN_RESIZING_FROM_ATTRIBUTE
	return TRUE;
}
	
	BOOL DynaBoxDlg::OnDestroy(void)
	{
		TreeNode tr = GetTree();
		
		///Cheney 2006-9-22 MOVE_BRANCH_LOADING_AND_SAVING_FROM_DYNABOX_TO_DYNADLG
		//---Cheney 2006-07-26 IF_NO_DIALOG_TITLE_NOT_LOAD_AND_SAVE
		//---Cheney 2006-06-21 QA70-8740 SAVING_BRANCH_IN_OPERATION_BASED_DIALOG
		//if(m_strTitle != "")
		//{
			//vector<byte> vbBranchSetting;
			//int nRet = m_DynaCntrl.GetCollapsed(vbBranchSetting, FALSE);
			//if(nRet < 0)
				//return false;
			//
			//if(nRet > 0) //if dialog has no branch, need not to save
			//{
				//BitsHex bh;
				//string	strBranchSetting;
				//if(!bh.BitsToHexStr(vbBranchSetting, strBranchSetting))
					//return false;
				//
				//if(!dlg_save_to_registry(m_strTitle, "Branch Setting", strBranchSetting))
					//return false;
			//}			
		//}
		//---end SAVING_BRANCH_IN_OPERATION_BASED_DIALOG
		//---end IF_NO_DIALOG_TITLE_NOT_LOAD_AND_SAVE
		SaveBranchSetting();
		///end MOVE_BRANCH_LOADING_AND_SAVING_FROM_DYNABOX_TO_DYNADLG
		
//--- CPY 7/1/06 REMOVE_SHIFT_SHOW_CHECK
//		m_nShiftShowCheck = m_chkShiftShow.Visible? m_chkShiftShow.Check : -1;
//---	

		///---Joseph 03/31/06 NOT_USE_THEME_DESCRIPTION_ANY_MORE
		//CheckThemeDescriptionChange(tr);
		///---End NOT_USE_THEME_DESCRIPTION_ANY_MORE
		
		tree_set_or_remove_attribute(tr, STR_SHOW_ADVANCED_ATTRIB,  isShowAdvanced());

		/// YuI 01/03/2005 v7.5183 QA70-7253 VECTORIAL_NUMERIC_FUNCTIONS
		// I am adding this as additional protection against OC runtime error which could
		// prevent EnableGUI execution when interactive control is destroyed
		Project.EnableGUI(TRUE);
		/// end VECTORIAL_NUMERIC_FUNCTIONS
		
		///Joseph 02/07/07 FIX_BUG_ON_MORE_PAGES
		Page pg = Project.Pages();
		if(pg)
			PostMessageOnObjectChange(false, pg);
		///End FIX_BUG_ON_MORE_PAGES
		/// YuI 09/16/09 QA70-13696 XFUNCTION_EVENT2_IMPLEMENTATION
		invokeBasicGlobalEvent(GETNE_ON_DESTORY);
		/// end XFUNCTION_EVENT2_IMPLEMENTATION
		return true;
	}

	#if _OC_VER >= 0x0800
	
	//---- CPY 12/23/04 QA70-7273 ADD_SHOW_ADVANCED_CHECK_BOX
	BOOL 	DynaBoxDlg::OnShowAdvancedCheck(Control oCntrl)
	{
		TreeNode tr = GetTree();
		//resizeDlgToFit(); cannot directly resize in message handler
		update_param_tree_advanced_ids(tr, isShowAdvanced());  ///Iris 12/24/04 GENERATE_READ_BUILD_IN_ADVAN_ID_THEME
		PostMessage(WM_USER_RECONSTRUCT, GRID_CHANGE_SHOW | GRID_CHANGE_SKIP_HANDLERS_ON_UPDATE);
		resizeDlgToFit();  /// TD 6-28-06
		return true;
	}
	//----
	
	///Iris 12/27/04 IMPROVE_ACCESS_ADVAN_IDS_THEME_FILE, move to analysis_utils
	/////Iris 12/24/04 GENERATE_READ_BUILD_IN_ADVAN_ID_THEME
	//static void _update_param_tree_by_advanced_ids_changed(TreeNode& trParam, bool bShow)
	//{
		//if(!trParam)
			//return;
		//
		//string strShow = bShow? "1" : "0";
		//vector<int> vnIDs;
		//if( _get_built_in_advanced_GUI_ids(vnIDs) )		
			//tree_set_attributes(trParam, vnIDs, strShow);		
	//}
	//
	//static void _generate_build_in_advanced_GUI_ids_theme_file(string strThemeFile) //template function here
	//{
		//Tree tr;
		//TreeNode trNodeID = tr.AddNode("IDs");
		//
		//vector<int> vnAdvanNodeIDs = {IDE_GEO_MEAN, IDE_LCI, IDE_UCI, IDE_SD_X_2, IDE_SD_X_3, IDE_MAD};
		//trNodeID.nVals = vnAdvanNodeIDs;
		//
		//tr.Save(strThemeFile);
	//}
	//
	//static bool _get_built_in_advanced_GUI_ids(vector<int>& vnIDs)
	//{
		//string strFilePath = theme_get_theme_file_name(ADVAN_ID_THEME_FILE);
		//if( !strFilePath.IsFile() )
			//_generate_build_in_advanced_GUI_ids_theme_file(strFilePath);
		//
		//if( !s_trAdvanIDs.FirstNode.IsValid() )
			//if( !s_trAdvanIDs.Load(strFilePath))
				//return false;
		//
		//vnIDs = s_trAdvanIDs.FirstNode.nVals;		
		//return true;
	//}		
	/////End GENERATE_READ_BUILD_IN_ADVAN_ID_THEME
	///End IMPROVE_ACCESS_ADVAN_IDS_THEME_FILE
	
	/*
	BOOL	DynaBoxDlg::OnSelectionChange()
	{
		return TREE_CTRL_VAR.OnSelectionChange();
	}
	
	BOOL	DynaBoxDlg::OnSelectionTrack()
	{
		return TREE_CTRL_VAR.OnSelectionTrack();
	}
	BOOL	OnDSSelectionTrack()
	{
		if( Visible )
			return m_treeEditCntrl.OnDSSelectionTrack();
	}
	
	BOOL	OnDSSelectionChange()
	{
		if( Visible )
			return m_treeEditCntrl.OnDSSelectionChange();
	}
	*/

	/// ML 2/14/2006 NEW_TREECONTROL_FOR_GetNBoxDlg
	// Yuri says these will be from now on be the business of the control:
	/*
	BOOL	DynaBoxDlg::OnInteractiveDataRange(Control ctrl)
	{
		Window wnd = GetWindow();
		return m_treeEditCntrl.DoInteractiveDlg(&wnd, TRUE, TRUE);
	}
	
	BOOL	DynaBoxDlg::OnInteractiveXYDataRange(Control ctrl)
	{
		Window wnd = GetWindow();
		return m_treeEditCntrl.DoXYDataRangeDlg(&wnd, TRUE);
	}
	
	BOOL	DynaBoxDlg::OnInteractivePopUp(Control ctrl)
	{
		Window wnd = GetWindow();
		RECT rectButton;
		ctrl.GetWindowRect(&rectButton);
		int nX = (rectButton.left + rectButton.right) / 2;
		int nY = (rectButton.top + rectButton.bottom) / 2;
		
		return m_treeEditCntrl.DoInteractivePopUp(&wnd, nX, nY);
	}
	/// end VECTORIAL_NUMERIC_FUNCTIONS
	*/
	/// end NEW_TREECONTROL_FOR_GetNBoxDlg
	

	
	

	#endif //if _OC_VER >= 0x0800
	
	////----- AW 10/02/06 QA80-9015 v8.0493 MORE_ON_ASCII_OPTION 
	void DynaBoxDlg::SetButtonText(LPCSTR lpcszOKText, LPCSTR lpcszApplyText)
	{
		if ( lpcszOKText  )
		{
			m_strbnOKText = lpcszOKText;
		}
		if ( lpcszApplyText )
		{
			m_strbnApplyText = lpcszApplyText;
		}
	}
	////----- END MORE_ON_ASCII_OPTION 



	BOOL DynaBoxDlg::OnApplyButton(Control cntrl)
	{
		PAPPLY_FUNC pfn = getApplyFunction();
		
		if(pfn)
		{
			//---- CPY 4/23/03 v7.0568 OPERATION_CLASS_NEED_TRY_AND_AUTO_UPDATE
			//bool bResult = s_pApplyFunc(THE_TREE_NODE);
			if(m_bUseTryForApply) // for Operation class Try case, use can still Cancel and can still OK
			{
				//m_input_tr.Replace(THE_TREE_NODE);		
				//pfn(m_input_tr); // must pass original treenode for operation to get_parent to get real tree
				TreeNode tr = UpdateInputTree();
				pfn(tr);
				
				return TRUE;
			}
			else
				pfn(GetTree());	
			//---- end OPERATION_CLASS_NEED_TRY_AND_AUTO_UPDATE
			
			enableButton(IDOK, false); // already apply, no need to do OK
			if(m_bApply1stTime)
			{
				Button cBtn = GetItem(IDCANCEL);
				cBtn.Text = "Close";
				m_bApply1stTime = false;
			}
		}
		////----- AW 10/02/06 QA80-9015 v8.0493 MORE_ON_ASCII_OPTION
		if ( !m_strbnApplyText.IsEmpty() )
		{
			//----------- CPY 2/19/07 CUSTOM_APPLY_BUTTONS_CLEANUP
			//m_bApplyBtnExit = true;
			m_nButtonExitEventID = GETNE_ON_APPLY;
			//-----------
			Close();
		}
		////----- END MORE_ON_ASCII_OPTION
		///Joseph 01/29/07 GETN_BOX_ADD_APPLY_BUTTON
		/// Iris 10/28/2008 QA80-12479 FIX_CANNOT_SHOW_APPLY_BTN_IN_SIMPLE_GETN
		//if(m_bShowApplyGetNEvent)
		if( isApplyButtonShow() )
		///end FIX_CANNOT_SHOW_APPLY_BTN_IN_SIMPLE_GETN
		{
			invokeBasicGlobalEvent(GETNE_ON_APPLY);
		}
		///End GETN_BOX_ADD_APPLY_BUTTON
		return TRUE;
	}

	///---Sim 07-27-2007 IMPLEMENT_APPLY_AND_UNDO_MECHANISM
	BOOL DynaBoxDlg::OnUndoButton(Control cntrl)
	{
		/// Iris 10/28/2008 QA80-12479 FIX_CANNOT_SHOW_APPLY_BTN_IN_SIMPLE_GETN
		//if(m_bShowApplyGetNEvent)
		if( isApplyButtonShow() )
		///end FIX_CANNOT_SHOW_APPLY_BTN_IN_SIMPLE_GETN	
		{
			invokeBasicGlobalEvent(GETNE_ON_UNDO);
		}
		return TRUE;
	}	
	///---END IMPLEMENT_APPLY_AND_UNDO_MECHANISM
	
	//------- CPY 6/11/03 QA70-4450 v7.0601 TTILE_KEY_TO_BECOME_MODLESS
	BOOL DynaBoxDlg::OnKey(BOOL bRollingUp)
	{
		if(!bRollingUp)
		{
			return FALSE;
		}
		return TRUE;
	}
	//------- end TTILE_KEY_TO_BECOME_MODLESS
	
	
	/// ML 2/14/2006 NEW_TREECONTROL_FOR_GetNBoxDlg
	/*
	//------------ vcFlex Grid Event Handlers ------------
	void DynaBoxDlg::OnAfterCollapse(Control cntrl, int nRow, short nState)
	{
		if(m_treeEditCntrl.IsResizeOnCollapse(nRow, nState))	//----CPY 8/24/03 v7.5674 QA70-5061 ADD_DISPLAY_OPTIONS
			resizeDlgToFit();
	}
	//--------- CPY 8/27/04 QA70-5890 v8.0125 BRANCH_ALLOW_CHECKBOX
	//virtual
	BOOL DynaBoxDlg::OnReconstructGrid(UINT wParam, UINT lParam)
	{
		BOOL bOK = TreeEditDlg::OnReconstructGrid(wParam, lParam);

		if(wParam & GRID_CHANGE_SHOW)
			resizeDlgToFit();
		
		return bOK;
	}
	//---------
	*/
	///------ Folger 03/08/10 QA81-15177 GETNBOX_SUPPORT_MOVE_FIRST_LEVEL_BRANCHES_INTO_TABS
	//BOOL DynaBoxDlg::OnAfterExpandCollapse(uint wParam, uint lParam)
	//{
		////---- CPY 3/17/06 DYNABOX_SIZE_CHANGING_ON_ANY_EDIT
		//if(wParam == OSC_ON_OTHER_CHANGES) // it comes here even if not related to branch open/close, and for those, we should not refit the dialog
			//return true;
		////----
		//resizeDlgToFit();
		//return TRUE;
	//}
	///------ End GETNBOX_SUPPORT_MOVE_FIRST_LEVEL_BRANCHES_INTO_TABS

	/// end NEW_TREECONTROL_FOR_GetNBoxDlg
	
	///Cheney 2006-9-22 MOVE_BRANCH_LOADING_AND_SAVING_FROM_DYNABOX_TO_DYNADLG	
	string DynaBoxDlg::GetDlgTitle()
	{
		return m_strTitle;
	}
	///end MOVE_BRANCH_LOADING_AND_SAVING_FROM_DYNABOX_TO_DYNADLG
		
	/// ML 2/14/2006 NEW_TREECONTROL_FOR_GetNBoxDlg
	/*
	///DG FIT_SIZE_WHEN_LIST_CHANGED
	void DynaBoxDlg::OnComboCloseUp(Control cntrl, int nRow, int nCol, BOOL* pFinishEdit)
	{
		TreeEditDlg::OnComboCloseUp(cntrl, nRow, nCol, pFinishEdit);
		int nxGrid, nyGrid;
		m_treeEditCntrl.GetGridSize(nxGrid, nyGrid);
		RECT r1;
		m_wndDlg.GetClientRect(&r1);
		if(nxGrid > RECT_WIDTH(r1))
			resizeDlgToFit();
	}
	///end FIT_SIZE_WHEN_LIST_CHANGED
	*/
	/// end NEW_TREECONTROL_FOR_GetNBoxDlg
	// return -1, 0 1, -1 if not applicable
//--- CPY 7/1/06 REMOVE_SHIFT_SHOW_CHECK
/*
	int	DynaBoxDlg::getShiftShowStatus()
	{
		if(m_strClassName.IsEmpty())
			return -1;
		//----- CPY 9/12/04 QA70-6682 GETN_THEME_SAVEAS_NEW_DIALOG
		//if(IDD_GETNBOX_THEME == m_nDlgID) /// Iris 5/16/05 THEME_WORK_FOR_ANALYSIS_DYNA_BOX
		if(IDD_DYNABOX_THEME == m_nDlgID) 
			return -1;
		//-----
		return shiftShow();
	}
	void DynaBoxDlg::updateShiftShowStatus()
	{
		if(!m_strClassName.IsEmpty() && m_nShiftShowCheck >= 0)
			shiftShow(false, m_nShiftShowCheck);
	}
	//bool GetNBoxDlg::shiftShow(bool bGet = true, bool bVal = false) /// Iris 9/15/04 MOVE_DECLARATION_TO_HEADER
	bool DynaBoxDlg::shiftShow(bool bGet, bool bVal)
	{
		Registry reg(HKEY_CURRENT_USER);
		string strKey = GetRegKey() + "\\Classes\\" + m_strClassName;
		string strVal = "GUI"; // we use just one dword
		DWORD	dwShiftShowBit = 0x00000001;
		
		DWORD dwVal = 0;
		if(bGet)
		{
			reg.GetValue(strKey, strVal, dwVal);
			return (dwVal & dwShiftShowBit)? true:false;
		}
		else
		{
			reg.GetValue(strKey, strVal, dwVal);
			if(bVal)
				dwVal |= dwShiftShowBit;
			else
				dwVal &=~dwShiftShowBit;
			
			reg.SetValue(strKey, strVal, dwVal);
		}
		return true;
	}
*/
//--- end REMOVE_SHIFT_SHOW_CHECK

	void	DynaBoxDlg::saveDefaultGUI()
	{
		if(!m_strClassName.IsEmpty())
			save_default_settings(GetTree(false), m_strClassName, SETTINGS_GUI);
	}
	// TD 5-2-06
	//moved to base class
	//PEVENT_FUNC DynaBoxDlg::getEventHandler()
	//{
	//	PEVENT_FUNC temp_pEventFunc = m_pEventFunc;// wait until we can call member function pointer directly
	//	TreeNode trNode = GetTree();
	//
	//	if(trNode)
	//		return temp_pEventFunc;
	//	
	//	return NULL;
	//}
	//----
	PAPPLY_FUNC DynaBoxDlg::getApplyFunction()
	{
		PAPPLY_FUNC temp_pApplyFunc = m_pApplyFunc;// wait until we can call member function pointer directly
		TreeNode trNode = GetTree();

		if(trNode)
			return temp_pApplyFunc;
		
		return NULL;
	}
	
	void DynaBoxDlg::enableButton(uint nBtnID, bool bEnable)
	{
		Control cBtn = GetItem(nBtnID);
		cBtn.Enable = bEnable;
	}
	void DynaBoxDlg::resizeDlgToFit(int cx, int cy)
	{
		/// ML 2/14/2006 NEW_TREECONTROL_FOR_GetNBoxDlg
		///// SY 07/27/2004 QA70-6719 v8.0105 GETN_AUTO_RESIZE_WIDTH_WITH_LONG_LABEL
		//if( !m_treeEditCntrl.IsReady() )
		//	return;
		///// end GETN_AUTO_RESIZE_WIDTH_WITH_LONG_LABEL
		/// end NEW_TREECONTROL_FOR_GetNBoxDlg
		///Joseph 02/05/07 DYNABOX_DLG_NEED_MORE_BTNS
		//uint nBtnIds[] = {
			//IDC_APPLY,
			//IDCANCEL,
			//IDOK,
			//0};
	//
		//uint nBtnNoApply[] = {
			//IDCANCEL,
			//IDOK,
			//0};
		//----------- CPY 2/19/07 CUSTOM_APPLY_BUTTONS_CLEANUP
		// base class position codes will automatically skip hidden buttons
		/*
		uint nBtnIds[] = {IDCANCEL, 0, 0, 0, 0, 0} ///for IDOK, IDC_APPLY, and cusom buttons
		uint nBtnNoApply[] = {IDC_APPLY,IDCANCEL, 0, 0, 0, 0, 0}	
		vector<uint> vnButtons = {IDOK, IDC_GETN_CUSTOM_BTN1, IDC_GETN_CUSTOM_BTN2, IDC_GETN_CUSTOM_BTN3};
		
		int nCustomButtonNum = vnButtons.GetSize();
		for(int ii = 0, jj= 0; ii < nCustomButtonNum; ii++)
		{
			if(!GetItem(vnButtons[ii]))
				continue;
			if(GetItem(vnButtons[ii]).Visible)
			{
				nBtnIds[ii + 1 - jj] = vnButtons[ii];
				nBtnNoApply[ii + 2 - jj] = vnButtons[ii];
			}
			else
				jj++;
		}			
		///End 	DYNABOX_DLG_NEED_MORE_BTNS
		///Joseph 01/29/07 GETN_BOX_ADD_APPLY_BUTTON
		if ( m_pApplyFunc || !m_strbnApplyText.IsEmpty() || m_bShowApplyGetNEvent)
		///End GETN_BOX_ADD_APPLY_BUTTON
			resizeDialog(nBtnIds, cx, cy);
		else
			resizeDialog(nBtnNoApply, cx, cy);
		*/
		///Joseph 03/09/07 CUSTOM_BUTTON_ORDER_ERROR
		///---Sim 07-27-2007 FIX_POS_OF_APPLY_UNDO_BTN_FOR_XF_DLG
		//uint nBtnIds[] = {IDCANCEL, IDC_APPLY, IDOK,  IDC_GETN_CUSTOM_BTN4, IDC_GETN_CUSTOM_BTN3, IDC_GETN_CUSTOM_BTN2, IDC_GETN_CUSTOM_BTN1, 0};
		uint nBtnIds[] = {IDCANCEL, IDOK, IDC_APPLY, IDC_UNDO_BTN, IDC_GETN_CUSTOM_BTN4, IDC_GETN_CUSTOM_BTN3, IDC_GETN_CUSTOM_BTN2, IDC_GETN_CUSTOM_BTN1, 0};
		///---END FIX_POS_OF_APPLY_UNDO_BTN_FOR_XF_DLG
		///End CUSTOM_BUTTON_ORDER_ERROR
		resizeDialog(nBtnIds, cx, cy);
		//----------
	}
	//--- CPY 12/23/04 QA70-7273 ADD_SHOW_ADVANCED_CHECK_BOX
	//bool GetNBoxDlg::isShowAdvanced()
	bool DynaBoxDlg::isShowAdvanced(TreeNode &tr)
	{
		///Frank 1/26/05	GETN_DLG_ADVANCED_CHECK_SAVE
		string str;
		if(tr)
			if(tr.GetAttribute(STR_SHOW_ADVANCED_ATTRIB,str))
				return true;
		///End	GETN_DLG_ADVANCED_CHECK_SAVE
			
		if(m_chkAdvanced)
		{
			if(m_chkAdvanced.Check)
				return true;
		}
		return false;
	}
	//---
	
// assume grid as top control underneath a caption and other controls follows in a row
// we assume the caption top position is unchanged
//void GetNBoxDlg::resizeDialog(uint* pIntIDs, int nCaptionID = IDC_PARAMS_DESCRIPTION) /// Iris 9/15/04 MOVE_DECLARATION_TO_HEADER

//----- CPY 6-30-06 QA70-8792 GETN_RESIZING_FROM_ATTRIBUTE, added cx, cy, used to be just (uint* pIntIDs)
// if cx=0, cy=0, then update dlg size from control size
// otherwise resize DynaControl to fit dlg cx cy
void DynaBoxDlg::resizeDialog(uint* pIntIDs, int cx, int cy)
{
	int nEdge = GetControlGap();
	int nGap = 8;
	int ny = nEdge;
			
	
	/// ML 2/14/2006 NEW_TREECONTROL_FOR_GetNBoxDlg
	//m_treeEditCntrl.GetGridSize(nxGrid, nyGrid);
	//// For now hard-wire:
	//nxGrid = 400;
	//yGrid = 500;
	int nxGrid = 400, nyGrid = 500;
	SIZE			sze;
	TREE_CTRL_VAR.GetOptimalSize(sze);
	nxGrid = sze.cx;
	nyGrid = sze.cy;
	/// end NEW_TREECONTROL_FOR_GetNBoxDlg
	
//printf("resizeDialog, GetGridSize width = %d, height=%d\n", nxGrid, nyGrid);
	
	///DG SUPPORT_MAX_HEIGHT_WIDTH_SETTING
	double dHeightPercent=0.6, dWidthPercent=0.8, dTemp;	//default
	int nMaxGridHeight, nMaxGridWidth;
	vector<string> vsHeightWidth;
	m_strMaxHeightWidth.GetTokens(vsHeightWidth, '|');
	for(int ii=0; ii<vsHeightWidth.GetSize(); ii++)
	{
		if(0 == ii)
		{
			dTemp=atof(vsHeightWidth[ii]);
			if(0 < dTemp)
				dHeightPercent=dTemp;
		}
		else if(1 == ii)
		{
			dTemp=atof(vsHeightWidth[ii]);
			if(0 < dTemp)
				dWidthPercent=dTemp;
		}
	}
	nMaxGridHeight = GetSystemMetrics(SM_CYSCREEN) * dHeightPercent;
	nMaxGridWidth = GetSystemMetrics(SM_CXSCREEN) * dWidthPercent;

	/// ML 4/6/2006 ACCOMMODATE_SCROLLBARS
	//if(nyGrid > nMaxGridHeight)
	//	nyGrid=nMaxGridHeight;
	//if(nxGrid > nMaxGridWidth)
	//	nxGrid=nMaxGridWidth;
	BOOL		bHorScrollbar = FALSE, bVertScrollBar = FALSE;
	if(nyGrid > nMaxGridHeight)
	{
		nyGrid=nMaxGridHeight;
		bVertScrollBar = TRUE;
	}
	if(nxGrid > nMaxGridWidth)
	{
		nxGrid=nMaxGridWidth;
		bHorScrollbar = TRUE;
	}
	
	if ( bVertScrollBar )
		nxGrid += GetSystemMetrics(SM_CXVSCROLL);
	if ( bHorScrollbar )
		nyGrid += GetSystemMetrics(SM_CYHSCROLL);
	/// end ACCOMMODATE_SCROLLBARS
	///end SUPPORT_MAX_HEIGHT_WIDTH_SETTING
	
	///------ Folger 03/08/10 QA81-15177 GETNBOX_SUPPORT_MOVE_FIRST_LEVEL_BRANCHES_INTO_TABS
	if ( DYNA_TAB_CNTRL )
	{
		RECT	rr;
		rr.right = nxGrid;
		rr.bottom = nyGrid;
		DYNA_TAB_CNTRL.AdjustRect(TRUE, &rr);
		nxGrid = rr.right - rr.left;
		nyGrid = rr.bottom - rr.top;
	}
	///------ End GETNBOX_SUPPORT_MOVE_FIRST_LEVEL_BRANCHES_INTO_TABS
	
	RECT r1, r2;
	Button btn = GetItem(pIntIDs[0]);
	btn.GetWindowRect(&r1);
	int nBtnWidth = r1.right - r1.left;
	int nBtnHeight= r1.bottom - r1.top;
	
	// next we caculate the size of dialog
	if(0==cx)
	{
		int nGroupWidth, nGroupHeight;
		cx = nEdge + nxGrid + nEdge;
		///DG MINI_SIZE_FOR_GETN_BOX
		GetGroupTotalSize(pIntIDs, nGroupWidth, nGroupHeight);
		if(nGroupWidth > cx)
			cx=nGroupWidth;
		///end MINI_SIZE_FOR_GETN_BOX
	}
	
	
	m_wndDlg.GetClientRect(&r1);
	int nOldDlgW = r1.right - r1.left;
	int nOldDlgH = (r1.bottom - r1.top);
	///DG SUPPORT_MAX_HEIGHT_WIDTH_SETTING
	//if(cx < nOldDlgW)
		//cx = nOldDlgW;
	///end SUPPORT_MAX_HEIGHT_WIDTH_SETTING

	ny = ResizeThemeControls(nEdge, cx, ny);

	//----- CPY 12/23/04 QA70-7273 ADD_SHOW_ADVANCED_CHECK_BOX
	// shift show check box is no longer used, so it is ok that we support only one check box at the bottom
	Button* pBottomCheckBox = NULL;
	//------ Iris 10/26/06 NOT_RESIZE_ADVANCED_CHECKBOX_IF_IS_HIDDEN
	//if(m_chkAdvanced)
	if(m_chkAdvanced && m_chkAdvanced.Visible)
	//------
		pBottomCheckBox = &m_chkAdvanced;
	//--- CPY 7/1/06 REMOVE_SHIFT_SHOW_CHECK
//	else
//	{
//		if(m_chkShiftShow)
//			pBottomCheckBox = &m_chkShiftShow;
//	}
	//---
	//------ end ADD_SHOW_ADVANCED_CHECK_BOX
		
	
	//---- CPY 5/22/03 v7.0589 SHIFT_SHOW_FOR_CLASSES
	int nCheckBoxes = 0;
	int nCheckBoxHeight = 0;
	if(pBottomCheckBox)
	{
		RECT rCheckBox;
		pBottomCheckBox->GetWindowRect(&rCheckBox);
		nCheckBoxHeight = rCheckBox.bottom - rCheckBox.top;
		nCheckBoxes = nEdge + nCheckBoxHeight + nEdge; 
	}
	//----
	//---------- CPY 10/29/06 QA70-9063 DYNAMIC_ERR_MSG_IN_GETN_DIALOGS_SMART_HEIGHT
	/*
	//--- Iris 10/24/06 ADD_ERR_MESSAGE_LINE
	RECT 	rErrMessageBox;
	int		nErrMessageHeight = 0;
	int		nErrMessage = 0;
	if( m_btnErrMessage )
	{
		m_btnErrMessage.GetWindowRect(&rErrMessageBox);
		nErrMessageHeight = rErrMessageBox.bottom - rErrMessageBox.top;
		nErrMessage = nEdge + nErrMessageHeight + nEdge;
	}
	//---
	*/
	int		nErrMessageHeight = GetDlgStatusMsgBoxHeight(cx - 2*nEdge );
	int		nErrMessage = nErrMessageHeight>0? nEdge + nErrMessageHeight + nEdge : 0;
	//---------- end DYNAMIC_ERR_MSG_IN_GETN_DIALOGS_SMART_HEIGHT
	
	if(0==cy)
	{
		//--- Iris 10/24/06 ADD_ERR_MESSAGE_LINE
		//cy = ny + nyGrid + nEdge + nCheckBoxes + nBtnHeight + nEdge;
		cy = ny + nyGrid + nEdge + nCheckBoxes + nBtnHeight + nEdge + nErrMessage;
		//---
		
		// we need to resize the dialog
		int nxDiff = cx - nOldDlgW;
		int nyDiff = cy - nOldDlgH;
		m_wndDlg.GetWindowRect(&r1);
		r1.right += nxDiff;
		r1.bottom += nyDiff;
		m_wndDlg.MoveWindow(&r1);
	}
	
	
	r2.top = ny;
	r2.left = nEdge;
	r2.right = cx - nEdge;
	//--- Iris 10/24/06 ADD_ERR_MESSAGE_LINE
	//r2.bottom = cy - 2*nEdge - nBtnHeight - nCheckBoxes;
	r2.bottom = cy - 2*nEdge - nBtnHeight - nCheckBoxes - nErrMessage;

	/// ML 2/14/2006 NEW_TREECONTROL_FOR_GetNBoxDlg
	//m_treeEditCntrl.MoveWindow(r2);
	///------ Folger 03/08/10 QA81-15177 GETNBOX_SUPPORT_MOVE_FIRST_LEVEL_BRANCHES_INTO_TABS
	if ( DYNA_TAB_CNTRL )
	{
		DYNA_TAB_CNTRL.MoveWindow(&r2);
		RECT	rrDyna;
		rrDyna = r2;
		DYNA_TAB_CNTRL.AdjustRect(FALSE, &rrDyna);
		TREE_CTRL_VAR.MoveWindow(&rrDyna);
	}
	else
	///------ End GETNBOX_SUPPORT_MOVE_FIRST_LEVEL_BRANCHES_INTO_TABS
	TREE_CTRL_VAR.MoveWindow(&r2);
	/// end NEW_TREECONTROL_FOR_GetNBoxDlg
	
	//--- Iris 10/24/06 ADD_ERR_MESSAGE_LINE
	if(nErrMessageHeight )
	{
		r2.top = r2.bottom + nEdge;
		r2.bottom = r2.top + nErrMessageHeight;		
		m_btnErrMessage.MoveWindow(&r2);
		m_btnErrMessage.Visible = true;
	}
	else
		m_btnErrMessage.Visible = false;
	//---

	//---- CPY 5/22/03 v7.0589 SHIFT_SHOW_FOR_CLASSES
	if(nCheckBoxHeight && pBottomCheckBox)
	{
		r2.top = ny + nyGrid + nEdge;
		//--- Iris 10/24/06 ADD_ERR_MESSAGE_LINE
		if(0 != nErrMessageHeight)
			r2.top = ny + nyGrid + nEdge + nErrMessageHeight + nEdge;
		//---
		r2.left = nEdge;
		r2.right = cx - nEdge;
		r2.bottom = r2.top + nCheckBoxHeight;
		pBottomCheckBox->MoveWindow(&r2);
	}
	//---- end 
	

	// now move the buttons to all along the bottom
	ArrangeControlsRightLeft(pIntIDs, cx, r2.bottom + nEdge);
/// end NEW_TREECONTROL_FOR_GetNBoxDlg
}
//}; ///Iris 9/15/04 MOVE_DECLARATION_TO_HEADER
///END GETNBOX_SAME_AS_GETNVIEWBOX
//--- CPY 8/22/06 this seems to be done else where, so I have to comment out
/*
/// TD 5-26-06 QA70-8428 EDITBOX_WITH_BUTTON
#define FILE_BROWSER   "...File:"
BOOL	DynaBoxDlg::OnGenericControlMsg(TreeNode &node, uint nCode)
{
	if(DGC_BUTTON_PATH == nCode)
	{
		string strNewVal = BrowseGetPath(node.strVal);
		if(!strNewVal.IsEmpty() && strNewVal.CompareNoCase(node.strVal))
		{
			node.strVal = strNewVal;
			return TRUE;
		}
		return FALSE;
	}

	if(DGC_BUTTON_FILE == nCode)
	{
		int nMrkerPreLen = lstrlen(FILE_BROWSER);
		string strCombo;
		if(node.GetAttribute(STR_COMBO_ATTRIB, strCombo) && strCombo.GetLength() > nMrkerPreLen)
		{
			strCombo = strCombo.Mid(nMrkerPreLen);
		}
		string strFileName = node.strVal;
		string strFilePath = GetFilePath(strFileName);
		StringArray saTypes;
		saTypes.Add(strCombo);

		string strFileNameNew =  GetOpenBox(saTypes, strFilePath, strFileName);
		if(!strFileNameNew.IsEmpty() && strFileNameNew.CompareNoCase(strFileName))
		{
			node.strVal = strFileNameNew;
			return TRUE;
		}
		return FALSE;
	}

	return FALSE;
}
/// end EDITBOX_WITH_BUTTON
*/

//----

bool	DynaBoxDlg::isShowAdvancedBox(TreeNode& tr)
{
	return false;	
}
///Joseph	12/07/06	ADD_MESSAGE_BOX
void 	DynaBoxDlg::OnAfterValueChange(int nRow, int nCol)	
{
	bool bOKEnable;
	if(! is_xf_gui_getn_tree(GetTree()))
	{
		///Joseph 01/29/07	ADD_OPERATION_ERRMSG_LINE
		//HandleOperFuncDlgErrMsg();
		invokeBasicGlobalEvent(GETNE_ON_VALUE_CHANGE);
		///End ADD_OPERATION_ERRMSG_LINE
	}
	
} 
///End	ADD_MESSAGE_BOX
void	DynaBoxDlg::OnInitChangeButtonText(LPCSTR lpcszText)
{
	Control ctrl = GetItem(IDC_APPLY);
	if(!ctrl)
		return ;
	string strButtonText(lpcszText);
	ctrl.Text = strButtonText;
}	
///End GETN_BOX_ADD_APPLY_BUTTON
//-------- CPY 2/24/2007 ADDING_CUSTOM_BUTTON4
/*
///Joseph 02/05/07 DYNABOX_DLG_NEED_MORE_BTNS
BOOL DynaBoxDlg::OnClickCustomButtom1(Control ctrl)
{
	invokeBasicGlobalEvent(GETNE_ON_CUSTOM_BUTTON1);
	return TRUE;
}

BOOL DynaBoxDlg::OnClickCustomButtom2(Control ctrl)
{
	invokeBasicGlobalEvent(GETNE_ON_CUSTOM_BUTTON2);
	return TRUE;
}

BOOL DynaBoxDlg::OnClickCustomButtom3(Control ctrl)
{
	invokeBasicGlobalEvent(GETNE_ON_CUSTOM_BUTTON3);
	return TRUE;
}
BOOL DynaBoxDlg::OnClickCustomButtom4(Control ctrl)
{
	invokeBasicGlobalEvent(GETNE_ON_CUSTOM_BUTTON4);
	return TRUE;
}
*/
BOOL DynaBoxDlg::OnClickCustomButton(int nID)
{
	if(nID >= IDC_GETN_CUSTOM_BTN1 && nID <= IDC_GETN_CUSTOM_BTN4)
		invokeBasicGlobalEvent(GETNE_ON_CUSTOM_BUTTON1 + (nID - IDC_GETN_CUSTOM_BTN1));
	else
		out_int("Invalid button id for custom button: ", nID);
	return TRUE;
}
//-------- end

///End DYNABOX_DLG_NEED_MORE_BTNS

//----------- CPY 2/19/07 CUSTOM_APPLY_BUTTONS_CLEANUP
///Joseph 02/14/07 SUPPORT_MORE_SPECAIL_EVENT
//virtual bool DynaBoxDlg::IsSpecialEvent(int nEventID)
//if(nEventID >= GETNE_ON_CUSTOM_BUTTON1 && nEventID <= GETNE_ON_CUSTOM_BUTTON3)
//{
	//return true;
//}
//return false;
////virtual 
//void DynaBoxDlg::OnSpecialButtons(int nEventID, const string& strAux)
//{
	//string strCmd = strAux;
	//if(! strCmd.Compare(DLG_NEED_CHANGE_GRID))
	//{
		//UpdateDynaControl(true, GETNEVENT_CHANGE_UPDATE_GUI_TREE);
	//}
//}

/// YuI 02/22/08 QA80-11156 DEFAULT_XF_APPLY_BUTTON_IMPLEMENTATION
///---Sim 02-28-2008 QA80-11156 XF_PANEL_APPLY_BUTTON
//bool	DynaBoxDlg::CheckApplyButtonEvent(TreeNode& trGetN, int nEventID, int nEventReturn)
bool	DynaBoxDlg::CheckApplyButtonEvent(TreeNode& trGetN, int nEventID, int nEventReturn, LPCSTR lpcszAux, int* pnApplyReturn)// = NULL)
///---END QA80-11156 XF_PANEL_APPLY_BUTTON
{
	///---Sim 02-28-2008 QA80-11156 XF_PANEL_APPLY_BUTTON
	//return DynaDlg::CheckApplyButtonEvent(trGetN, nEventID, nEventReturn);
	return DynaDlg::CheckApplyButtonEvent(trGetN, nEventID, nEventReturn, lpcszAux, pnApplyReturn);
	///---END QA80-11156 XF_PANEL_APPLY_BUTTON
}
/// end DEFAULT_XF_APPLY_BUTTON_IMPLEMENTATION
	
/////Joseph 01/29/07 GETN_BOX_ADD_APPLY_BUTTON
//void	DynaBoxDlg::OnCustomButtonCloseDialog(int nEventID, int nReturnValue)	
//{		
	//if(PEVENT_GETN_RET_TO_CLOSE == nReturnValue)
	//{
		//Close();
		//m_bApplyBtnExit = true;
	//}
//}
bool DynaBoxDlg::CheckCustomBottonEvents(int nEventID, int nEventRet, const string& strAux)
{
	if(nEventID >= GETNE_ON_CUSTOM_BUTTON1 && nEventID <= GETNE_ON_CUSTOM_BUTTON4)
	{
		///---Sim 10-31-2008 INDICATE_THEME_ON_PA_FIT_PARAM_CHANGE
		/*
		///---Sim 12-06-2007 IMPROVE_EVENT1_PARAM_STR_AUX
		//if(strAux.Compare(DLG_NEED_CHANGE_GRID) == 0)
		if ( is_aux_value(strAux, DLG_NEED_CHANGE_GRID) )
		///---END IMPROVE_EVENT1_PARAM_STR_AUX
			UpdateDynaControl(true, GETNEVENT_ON_CHANGE_UPDATE_GUI);
		*/
		DynaDlg::CheckCustomBottonEvents(nEventID, nEventRet, strAux);
		///---END INDICATE_THEME_ON_PA_FIT_PARAM_CHANGE
		if(PEVENT_GETN_RET_TO_CLOSE == nEventRet)
		{
			Close();
			m_nButtonExitEventID = nEventID;
		}
		return true;
	}
	return false;
}
bool DynaBoxDlg::CheckSpecialExit(int& nRet)
{
	///---Sim 03-24-2007 FIX_CUSTOM_BUTTON all event id should less then zero
	//if(m_nButtonExitEventID <= 0)
	if(m_nButtonExitEventID == 0)
	///---END FIX_CUSTOM_BUTTON
		return false;
	
	if(GETNE_ON_APPLY == m_nButtonExitEventID)
		nRet = IDC_APPLY;
	else if(m_nButtonExitEventID >= GETNE_ON_CUSTOM_BUTTON1 && m_nButtonExitEventID <= GETNE_ON_CUSTOM_BUTTON4)
		nRet = IDC_GETN_CUSTOM_BTN1 + (m_nButtonExitEventID - GETNE_ON_CUSTOM_BUTTON1);
	else
		out_int("error exit event found:", m_nButtonExitEventID);
	
	return true;
}
/////End SUPPORT_MORE_SPECAIL_EVENT
